function cb_m32
% Menu 32
% Calculate R0 and Rv

  global Cc                   
  global Rv                   
  global Rt
  global Ct
  global isGitLoad
  global sR0                  
  global isR0Variable        
  global sC0                 
  global sLs                 
  global sRs                     
  global m32
  global sfontsize
  global persParamsDir
  
  Rfull = 10e3;
  Rmax = 130e3; 
  
  kw=20/sfontsize;
  capt = get(m32,'label');  
  rowscols = [1,30*kw; 1,30*kw];
  prompt={};
  prompt{1} = 'Rfull / kOhm';
  prompt{2} = 'Rmax / kOhm';
  defaults{1} = num2str(Rfull /1000,4);
  defaults{2} = num2str(Rmax/1000,4);
  
  result= inputdlg (prompt, capt, rowscols, defaults);
  
  if ~isempty(result)
    
    num=real(str2num(result{1}));    
    if ~isempty(num)
      Rfull=num(1,1)*1000;
      if (Rfull < 100) Rfull = 100; end
      if (Rfull > 10e9) Rfull = 10e9; end 
    end 
    num=real(str2num(result{2})); 
    if ~isempty(num)   
      Rmax=num(1,1)*1000;
      if (Rmax < 100) Rmax = 100; end
      if (Rmax > 10e9) Rmax = 10e9; end 
    end      
    
    aux = sqrt(4*Rmax ^2-4*Rmax*Rfull);
    Rv = 2 * Rmax + aux;
    sR0= 2 * Rmax - aux;
    
    sn = strcat(persParamsDir,'gitParams.mat');
    save('-mat',sn, 'Rv', 'Rt' , 'Ct','isGitLoad');
    
    sn = strcat(persParamsDir,'approxStartValues.mat');
    save('-mat',sn, 'sR0', 'isR0Variable', 'sC0', 'sLs', 'sRs');
    
    capt='Result:';
    rowscols = [1,30*kw; 1,30*kw];
    prompt={};
    prompt{1} = 'Rv / kOhm';
    prompt{2} = 'R0 / kOhm';
    defaults = {};  
    defaults{1} = num2str(Rv /1000,4);
    defaults{2} = num2str(sR0/1000,4);
    
    result= inputdlg (prompt, capt, rowscols, defaults);
    
  end
end 